
		include	ht66f2370.inc
					
LED1O				EQU	PG7
LED2O			   EQU	PG6
LED3O			   EQU	PG5
LED4O			   EQU	PG4
LEDPO			   EQU	PG3

LED1OM         EQU   10000000B
LED2OM         EQU   01000000B
LED3OM         EQU   00100000B
LED4OM         EQU   00010000B
LEDPOM         EQU   00001000B

LED1N          EQU   0
LED2N          EQU   1
LED3N          EQU   2
LED4N          EQU   3
LEDPN          EQU   4

LED1NM         EQU   00000001B
LED2NM         EQU   00000010B
LED3NM         EQU   00000100B
LED4NM         EQU   00001000B
LEDPNM         EQU   00010000B
;-------------------------------------------------------------------------;
RAMBANK	23		@LED_data
@LED_data	   .section 'data'
_LEDFlashStatus   db    0
_LEDFlashTimer	   db    10 dup(?)
_LEDFlashTmCnt	   db    10 dup(?)
      public   _LEDFlashStatus
      public   _LEDFlashTimer
      public   _LEDFlashTmCnt
;-------------------------------------------------------------------------;
@LED_code      .section 'code'
;-------------------------------------------------------------------------;
;void LED_InterfaceConfigure(void)
;-------------------------------------------------------------------------;
      public   _LED_InterfaceConfigure
_LED_InterfaceConfigure proc
	   mov      A,03Fh
	   landm    A,PGS0            ;PG3 to GPIO
	   lclr     PGS1              ;PG4~PG7 to GPIO
	   mov      A,007H
	   andm     A,PGC             ;PG3~PG7 to output mode
	   mov      A,0F8H
	   orm      A,PG              ;PG3~PG7 out HIGH
	   lclr     _LEDFlashStatus
	   mov      A,low(offset _LEDFlashTimer)
	   mov      MP2L,A
	   mov      A,high(offset _LEDFlashTimer)
	   mov      MP2H,A
	   mov      A,20
_@L1:	   
	   clr      IAR2
	   siz      MP2L
	   jmp      $+2
	   inc      MP2H
	   sdz      ACC
	   jmp      _@L1
	   ret
_LED_InterfaceConfigure endp
;-------------------------------------------------------------------------;
;void LED_AlwaysOn(u8 led)
;led.0 -->LED1
;led.1 -->LED2
;led.2 -->LED3
;led.3 -->LED4
;led.4 -->LEDP
;-------------------------------------------------------------------------;
      public   _LED_AlwaysOn 
      public	_LED_AlwaysOn_2     
_LED_AlwaysOn proc
      local    _LED_AlwaysOn_2 db 4 dup(?)	; 0,4
	   mov      _LED_AlwaysOn_2[3],A
	   mov      A,LED1NM
	   mov      _LED_AlwaysOn_2[1],A
	   mov      A,LED1OM
	   mov      _LED_AlwaysOn_2[0],A
	   clr      _LED_AlwaysOn_2[2]
	   jmp      _L3
_L5:
      mov      A,_LED_AlwaysOn_2[1]
	   and      A,_LED_AlwaysOn_2[3]
	   snz      ACC
	   jmp      _L4
	   cpla     _LED_AlwaysOn_2[1]
	   landm    A,_LEDFlashStatus
	   cpla     _LED_AlwaysOn_2[0]
	   andm     A,PG
_L4:
	   rl       _LED_AlwaysOn_2[1]
	   rr       _LED_AlwaysOn_2[0]
	   inc      _LED_AlwaysOn_2[2]
_L3:
	   mov      A,4
	   sub      A,_LED_AlwaysOn_2[2]
	   sz       C
	   jmp      _L5
	   ret
_LED_AlwaysOn endp
;-------------------------------------------------------------------------;
;void LED_AlwaysOff(u8 led)
;led.0 -->LED1
;led.1 -->LED2
;led.2 -->LED3
;led.3 -->LED4
;led.4 -->LEDP
;-------------------------------------------------------------------------;
      public   _LED_AlwaysOff
_LED_AlwaysOff proc
      local    _LED_AlwaysOff_2 db 4 dup(?)	; 0,4
	   mov      _LED_AlwaysOff_2[3],A
	   mov      A,LED1NM
	   mov      _LED_AlwaysOff_2[1],A
	   mov      A,LED1OM
	   mov      _LED_AlwaysOff_2[0],A
	   clr      _LED_AlwaysOff_2[2]
	   jmp      _L11
_L13:
	   mov      A,_LED_AlwaysOff_2[1]
	   and      A,_LED_AlwaysOff_2[3]
	   snz      ACC
	   jmp      _L12
	   cpla     _LED_AlwaysOn_2[1]
	   landm    A,_LEDFlashStatus
	   mov      A,_LED_AlwaysOn_2[0]
	   orm      A,PG
_L12:
	   rl       _LED_AlwaysOff_2[1]
	   rr       _LED_AlwaysOff_2[0]
	   inc      _LED_AlwaysOff_2[2]
_L11:
	   mov      A,4
	   sub      A,_LED_AlwaysOff_2[2]
	   sz       C
	   jmp      _L13
	   ret
_LED_AlwaysOff endp
;-------------------------------------------------------------------------;
;void LED_FlashEnable(u8 led,u16 timer)
;led.0 -->LED1
;led.1 -->LED2
;led.2 -->LED3
;led.3 -->LED4
;led.4 -->LEDP
;-------------------------------------------------------------------------;
      public   _LED_FlashEnable
      public   _LED_FlashEnable_2      
_LED_FlashEnable proc
      local    _LED_FlashEnable_2 db 6 dup(?)	; 2,4
	   mov      _LED_FlashEnable_2[5],A
	   mov      A,LED1NM
	   mov      _LED_FlashEnable_2[3],A
	   mov      A,LED1OM
	   mov      _LED_FlashEnable_2[2],A
	   clr      _LED_FlashEnable_2[4]
	   jmp      _L18
_L20:
	   mov      A,_LED_FlashEnable_2[3]
	   and      A,_LED_FlashEnable_2[5]
	   snz      ACC
	   jmp      _L19
	   mov      A,_LED_FlashEnable_2[3]
	   lorm     A,_LEDFlashStatus
	   mov      A,low(offset _LEDFlashTimer)
      mov      MP2L,A
	   mov      A,high(offset _LEDFlashTimer)
      mov      MP2H,A
	   rla      _LED_FlashEnable_2[4]
	   addm     A,MP2L
	   mov      A,00
	   adcm     A,MP2H
	   mov      A,_LED_FlashEnable_2[0]
	   mov      IAR2,A
	   inc      MP2L
	   mov      A,_LED_FlashEnable_2[1]
	   mov      IAR2,A
	   mov      A,10-1
	   addm     A,MP2L
	   mov      A,00
	   adcm     A,MP2H
	   mov      A,_LED_FlashEnable_2[0]
	   mov      IAR2,A
	   inc      MP2L
	   mov      A,_LED_FlashEnable_2[1]
	   mov      IAR2,A	   
	   cpla     _LED_FlashEnable_2[2]
	   andm     A,PG
_L19:
	   rl       _LED_FlashEnable_2[3]
	   rr       _LED_FlashEnable_2[2]
	   inc      _LED_FlashEnable_2[4]
_L18:
	   mov      A,4
	   sub      A,_LED_FlashEnable_2[4]
	   sz       C
	   jmp      _L20
	   ret
_LED_FlashEnable endp
;-------------------------------------------------------------------------;
;void LED_FlashProcess(void)
;-------------------------------------------------------------------------;
      public   _LED_FlashProcess
_LED_FlashProcess proc
      local    _LED_FlashProcess_2 db 3 dup(?)	; 0,2
      mov      A,LED1NM
	   mov      _LED_FlashProcess_2[1],A      
	   mov      A,LED1OM
	   mov      _LED_FlashProcess_2[0],A
	   clr      _LED_FlashProcess_2[2]
	   jmp      _L25
_L29:
      mov      A,_LED_FlashProcess_2[1]
      land     A,_LEDFlashStatus
      snz      ACC
	   jmp      _L27
	   mov      A,low(offset _LEDFlashTmCnt)
	   mov      MP2L,A
	   mov      A,high(offset _LEDFlashTmCnt)
	   mov      MP2H,A
	   rla      _LED_FlashProcess_2[2]
	   addm     A,MP2L
	   mov      A,00
	   adcm     A,MP2H
	   mov      A,255
	   addm     A,IAR2
	   inc      MP2L
	   mov      A,255
	   adcm     A,IAR2
	   mov      A,IAR2
	   dec      MP2L
	   or       A,IAR2
	   sz       ACC
	   jmp      _L27
	   mov      A,low(offset _LEDFlashTimer)
	   mov      MP1L,A
	   mov      A,high(offset _LEDFlashTimer)
	   mov      MP1H,A
	   rla      _LED_FlashProcess_2[2]
	   addm     A,MP1L
	   mov      A,00
	   adcm     A,MP1H
	   mov      A,IAR1
	   mov      IAR2,A
	   inc      MP1L
	   inc      MP2L
	   mov      A,IAR1
	   mov      IAR2,A
	   
	   mov      A,_LED_FlashProcess_2[0]
	   xorm     A,PG
_L27:
      rl       _LED_FlashProcess_2[1]
	   rr       _LED_FlashProcess_2[0]
	   inc      _LED_FlashProcess_2[2]
_L25:
	   mov      A,4
	   sub      A,_LED_FlashProcess_2[2]
	   sz       C
	   jmp      _L29
	   ret
_LED_FlashProcess endp
;-------------------------------------------------------------------------;
      end